# Generated Python Strategy for: PlayerB (meta)
# Run Index: 2
# Primary LLM: DeepSeek-V3 (deepseek-ai/DeepSeek-V3-0324) Provider: novita
def PlayerB_DeepSeek_V3_MetaAgent_Run2_Iter1(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    # Initial move: Cooperate
    if not my_history:
        return "C"
    
    # Heuristic analysis of opponent's code
    opponent_code = opponent_program_code.lower()
    
    # Check for always_cooperate or always_defect
    if "always_cooperate" in opponent_code or "return 'c'" in opponent_code or "return c" in opponent_code:
        return "C"
    if "always_defect" in opponent_code or "return 'd'" in opponent_code or "return d" in opponent_code:
        return "D"
    
    # Check for tit-for-tat-like behavior (look for history checks)
    tit_for_tat_indicators = [
        "opp_history[-1]",
        "opp_history[len(opp_history)-1]",
        "if opp_history:",
        "return opp_history[-1]",
        "return my_history[-1]"
    ]
    if any(indicator in opponent_code for indicator in tit_for_tat_indicators):
        return opp_history[-1] if opp_history else "C"
    
    # Check for random behavior
    if "random.choice" in opponent_code or "random.randint" in opponent_code:
        return "D"  # Defect against random strategies
    
    # Check for code length (short code might be simple strategies)
    if len(opponent_program_code.splitlines()) < 5:
        return "C"  # Cooperate with simple strategies
    
    # Check for self-similarity (if opponent's code resembles our own)
    our_keywords = ["deepseek", "metaagent", "v3", "run2", "iter1"]
    if any(keyword in opponent_code for keyword in our_keywords):
        return "C"  # Cooperate with similar agents
    
    # Fallback: Tit-for-Tat with initial forgiveness
    if opp_history[-1] == "C":
        return "C"
    else:
        return "D"